/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_core.netty;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonSyntaxException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultFileRegion;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import pl.skidam.automodpack_core.GlobalVariables;
import pl.skidam.automodpack_core.modpack.ModpackContent;
import pl.skidam.automodpack_core.netty.HttpResponse;
import pl.skidam.automodpack_core.netty.HttpServer;

public class HttpServerHandler
extends ChannelInboundHandlerAdapter {
    public boolean isAutoModpackRequest(ByteBuf buf) {
        boolean equals = false;
        try {
            buf.markReaderIndex();
            byte[] data1 = new byte[HttpServer.HTTP_REQUEST_GET_BASE_BYTES.length];
            buf.readBytes(data1);
            buf.resetReaderIndex();
            byte[] data2 = new byte[HttpServer.HTTP_REQUEST_REFRESH_BYTES.length];
            buf.readBytes(data2);
            buf.resetReaderIndex();
            equals = Arrays.equals(data1, HttpServer.HTTP_REQUEST_GET_BASE_BYTES) || Arrays.equals(data2, HttpServer.HTTP_REQUEST_REFRESH_BYTES);
        }
        catch (IndexOutOfBoundsException data1) {
        }
        catch (Exception e) {
            GlobalVariables.LOGGER.error("Couldn't read channel!", (Throwable)e);
        }
        return equals;
    }

    private String parseRequestUri(String request) {
        String[] requestLines = request.split("\r\n");
        String[] requestFirstLine = requestLines[0].split(" ");
        String requestUrl = requestFirstLine[1];
        if (requestUrl.contains("/automodpack/")) {
            return requestUrl.replaceFirst("/automodpack/", "");
        }
        return null;
    }

    public List<String> parseBodyStrings(String requestPacket) {
        ArrayList<String> stringList = new ArrayList<String>();
        if (!requestPacket.contains("[")) {
            return stringList;
        }
        String jsonPart = requestPacket.substring(requestPacket.lastIndexOf("[")).trim();
        try {
            JsonArray jsonArray = (JsonArray)new Gson().fromJson(jsonPart, JsonArray.class);
            for (int i = 0; i < jsonArray.size(); ++i) {
                stringList.add(jsonArray.get(i).getAsString());
            }
        }
        catch (JsonSyntaxException e) {
            e.printStackTrace();
        }
        return stringList;
    }

    private String getRequest(ByteBuf buf) {
        try {
            buf.markReaderIndex();
            if (buf.readableBytes() > 4096 || buf.readableBytes() < "/automodpack/".length()) {
                return null;
            }
            byte[] data = new byte[buf.readableBytes()];
            buf.readBytes(data);
            buf.resetReaderIndex();
            return new String(data);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void channelRead(ChannelHandlerContext context, Object msg) {
        this.channelRead(context, (ByteBuf)msg);
    }

    public void channelRead(ChannelHandlerContext context, ByteBuf buf) {
        String request = this.getRequest(buf);
        if (request == null) {
            return;
        }
        String requestUri = this.parseRequestUri(request);
        if (requestUri == null) {
            return;
        }
        ChannelHandlerContext firstContext = context.pipeline().firstContext();
        if (request.contains("GET /automodpack/")) {
            this.sendFile(firstContext, requestUri);
        } else if (request.contains("POST /automodpack/refresh")) {
            this.refreshModpackFiles(firstContext, request);
        }
        buf.release();
    }

    private void refreshModpackFiles(ChannelHandlerContext context, String request) {
        List<String> hashes = this.parseBodyStrings(request);
        GlobalVariables.LOGGER.info("Received refresh request for files of hashes: {}", hashes);
        ArrayList<CompletableFuture<Void>> creationFutures = new ArrayList<CompletableFuture<Void>>();
        ArrayList<ModpackContent> modpacks = new ArrayList<ModpackContent>();
        for (String hash : hashes) {
            Optional<Path> optionalPath = this.resolvePath(hash);
            if (optionalPath.isEmpty()) continue;
            Path path = optionalPath.get();
            ModpackContent modpack = null;
            for (ModpackContent content : GlobalVariables.modpack.modpacks.values()) {
                if (!content.pathsMap.getMap().containsKey(hash)) continue;
                modpack = content;
                break;
            }
            if (modpack == null) continue;
            modpacks.add(modpack);
            creationFutures.add(modpack.replaceAsync(path));
        }
        creationFutures.forEach(CompletableFuture::join);
        modpacks.forEach(ModpackContent::saveModpackContent);
        GlobalVariables.LOGGER.info("Sending new modpack-content.json");
        this.sendFile(context, "");
    }

    private void sendFile(ChannelHandlerContext context, String requestUri) {
        RandomAccessFile raf;
        Optional<Path> optionalPath = this.resolvePath(requestUri);
        if (optionalPath.isEmpty()) {
            this.sendError(context, 404);
            return;
        }
        Path path = optionalPath.get();
        try {
            raf = new RandomAccessFile(path.toFile(), "r");
        }
        catch (FileNotFoundException e) {
            this.sendError(context, 404);
            GlobalVariables.LOGGER.error("Requested file not found!", e.getCause());
            return;
        }
        catch (Exception e) {
            this.sendError(context, 418);
            GlobalVariables.LOGGER.error("Failed to open the file {}", (Object)path, (Object)e);
            return;
        }
        try {
            long fileLength = raf.length();
            HttpResponse response = new HttpResponse(200);
            response.addHeader("Content-Type", "application/octet-stream");
            response.addHeader("Content-Length", String.valueOf(fileLength));
            ByteBuf responseHeadersBuf = Unpooled.copiedBuffer((CharSequence)response.getResponseMessage(), (Charset)StandardCharsets.UTF_8);
            context.pipeline().firstContext().write((Object)responseHeadersBuf);
            DefaultFileRegion fileRegion = new DefaultFileRegion(raf.getChannel(), 0L, fileLength);
            context.pipeline().firstContext().writeAndFlush((Object)fileRegion, (ChannelPromise)context.newProgressivePromise()).addListener(future -> {
                if (!future.isSuccess()) {
                    GlobalVariables.LOGGER.error("Writing to channel error! " + String.valueOf(future.cause()) + " " + future.cause().getMessage());
                }
                raf.close();
                context.pipeline().firstContext().channel().close();
            });
        }
        catch (Exception e) {
            GlobalVariables.LOGGER.error("Couldn't read channel!", (Throwable)e);
        }
    }

    public void exceptionCaught(ChannelHandlerContext context, Throwable cause) {
        GlobalVariables.LOGGER.error("Couldn't handle HTTP request!" + String.valueOf(cause));
    }

    private void sendError(ChannelHandlerContext context, int status) {
        HttpResponse response = new HttpResponse(status);
        response.addHeader("Content-Length", String.valueOf(0));
        ByteBuf responseBuf = Unpooled.copiedBuffer((CharSequence)response.getResponseMessage(), (Charset)StandardCharsets.UTF_8);
        context.pipeline().firstContext().writeAndFlush((Object)responseBuf).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public Optional<Path> resolvePath(String sha1) {
        if (sha1.isBlank()) {
            return Optional.of(GlobalVariables.hostModpackContentFile);
        }
        return GlobalVariables.httpServer.getPath(sha1);
    }
}

