/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_core.utils;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import pl.skidam.automodpack_core.GlobalVariables;
import pl.skidam.automodpack_core.loader.LoaderService;
import pl.skidam.automodpack_core.utils.ManifestReader;
import reloc.org.tomlj.Toml;
import reloc.org.tomlj.TomlArray;
import reloc.org.tomlj.TomlParseResult;
import reloc.org.tomlj.TomlTable;

public class FileInspection {
    private static final String forbiddenChars = "\\/:*\"<>|!?.";

    public static boolean isMod(Path file) {
        if (!file.getFileName().toString().endsWith(".jar")) {
            return false;
        }
        return FileInspection.getModID(file) != null;
    }

    public static Path getAutoModpackJar() {
        try {
            URI uri = FileInspection.class.getProtectionDomain().getCodeSource().getLocation().toURI();
            String path = uri.getPath();
            int index = path.indexOf(33);
            if (index != -1) {
                path = path.substring(0, index);
            }
            if ((index = path.indexOf(35)) != -1) {
                path = path.substring(0, index);
            }
            if (System.getProperty("os.name").toLowerCase().contains("win") && path.startsWith("/")) {
                path = path.substring(1);
            }
            return Path.of(path, new String[0]).toAbsolutePath().normalize();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean hasSpecificServices(Path file) {
        if (!file.getFileName().toString().endsWith(".jar")) {
            return false;
        }
        try {
            ZipFile zipFile = new ZipFile(file.toFile());
            ZipEntry forgeIModLocator = zipFile.getEntry("META-INF/services/net.minecraftforge.forgespi.locating.IModLocator");
            ZipEntry forgeIDependencyLocator = zipFile.getEntry("META-INF/services/net.minecraftforge.forgespi.locating.IDependencyLocator");
            ZipEntry neoforgeIModLocator = zipFile.getEntry("META-INF/services/net.neoforged.neoforgespi.locating.IModLocator");
            ZipEntry neoforgeIDependencyLocator = zipFile.getEntry("META-INF/services/net.neoforged.neoforgespi.locating.IDependencyLocator");
            ZipEntry neoforgeIModFileCandidateLocator = zipFile.getEntry("META-INF/services/net.neoforged.neoforgespi.locating.IModFileCandidateLocator");
            ZipEntry neoforgeGraphicsBootstrapper = zipFile.getEntry("META-INF/services/net.neoforged.neoforgespi.earlywindow.GraphicsBootstrapper");
            zipFile.close();
            return forgeIModLocator != null || forgeIDependencyLocator != null || neoforgeIModLocator != null || neoforgeIDependencyLocator != null || neoforgeIModFileCandidateLocator != null || neoforgeGraphicsBootstrapper != null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String getModID(Path file) {
        if (!file.getFileName().toString().endsWith(".jar")) {
            return null;
        }
        String modID = null;
        try {
            ZipFile zipFile = new ZipFile(file.toFile());
            ZipEntry entry = null;
            if (zipFile.getEntry("fabric.mod.json") != null) {
                entry = zipFile.getEntry("fabric.mod.json");
            } else if (zipFile.getEntry("quilt.mod.json") != null) {
                entry = zipFile.getEntry("quilt.mod.json");
            } else if (zipFile.getEntry("META-INF/mods.toml") != null) {
                entry = zipFile.getEntry("META-INF/mods.toml");
            } else if (zipFile.getEntry("META-INF/neoforge.mods.toml") != null) {
                entry = zipFile.getEntry("META-INF/neoforge.mods.toml");
            }
            if (entry == null) {
                zipFile.close();
                return null;
            }
            Gson gson = new Gson();
            InputStream stream = zipFile.getInputStream(entry);
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            if (entry.getName().equals("META-INF/mods.toml") || entry.getName().equals("META-INF/neoforge.mods.toml")) {
                TomlParseResult result = Toml.parse(reader);
                result.errors().forEach(error -> GlobalVariables.LOGGER.error(error.toString()));
                TomlArray array = result.getArray("mods");
                if (array != null) {
                    for (Object o : array.toList()) {
                        TomlTable mod = (TomlTable)o;
                        if (mod == null) continue;
                        modID = mod.getString("modId");
                    }
                }
            } else {
                JsonObject quiltLoader;
                JsonObject json = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
                if (entry.getName().equals("fabric.mod.json")) {
                    if (json.has("id")) {
                        modID = json.get("id").getAsString();
                    }
                } else if (entry.getName().equals("quilt.mod.json") && json.has("quilt_loader") && (quiltLoader = json.get("quilt_loader").getAsJsonObject()).has("id")) {
                    modID = quiltLoader.get("id").getAsString();
                }
            }
            reader.close();
            stream.close();
            zipFile.close();
        }
        catch (ZipException zipFile) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return modID;
    }

    public static Set<String> getModDependencies(Path file) {
        if (!file.getFileName().toString().endsWith(".jar")) {
            return Set.of();
        }
        HashSet<String> dependencies = new HashSet<String>();
        try {
            ZipFile zipFile = new ZipFile(file.toFile());
            ZipEntry entry = null;
            if (zipFile.getEntry("fabric.mod.json") != null) {
                entry = zipFile.getEntry("fabric.mod.json");
            } else if (zipFile.getEntry("quilt.mod.json") != null) {
                entry = zipFile.getEntry("quilt.mod.json");
            } else if (zipFile.getEntry("META-INF/mods.toml") != null) {
                entry = zipFile.getEntry("META-INF/mods.toml");
            } else if (zipFile.getEntry("META-INF/neoforge.mods.toml") != null) {
                entry = zipFile.getEntry("META-INF/neoforge.mods.toml");
            }
            if (entry == null) {
                zipFile.close();
                return null;
            }
            Gson gson = new Gson();
            InputStream stream = zipFile.getInputStream(entry);
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            if (entry.getName().equals("META-INF/mods.toml") || entry.getName().equals("META-INF/neoforge.mods.toml")) {
                TomlParseResult result = Toml.parse(reader);
                result.errors().forEach(error -> GlobalVariables.LOGGER.error(error.toString()));
                String modID = FileInspection.getModID(file);
                TomlArray array = result.getArray("dependencies.\"" + modID + "\"");
                if (array != null) {
                    for (Object o : array.toList()) {
                        TomlTable mod = (TomlTable)o;
                        if (mod == null) continue;
                        dependencies.add(mod.getString("modId"));
                    }
                }
            } else {
                JsonObject depends;
                JsonObject quiltLoader;
                JsonObject json = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
                if (entry.getName().equals("fabric.mod.json")) {
                    JsonObject depends2;
                    if (json.has("depends") && (depends2 = json.get("depends").getAsJsonObject()) != null) {
                        dependencies.addAll(depends2.entrySet().stream().map(Map.Entry::getKey).toList());
                    }
                } else if (entry.getName().equals("quilt.mod.json") && json.has("quilt_loader") && (quiltLoader = json.get("quilt_loader").getAsJsonObject()).has("depends") && (depends = quiltLoader.get("depends").getAsJsonObject()) != null) {
                    dependencies.addAll(depends.entrySet().stream().map(Map.Entry::getKey).toList());
                }
            }
            reader.close();
            stream.close();
            zipFile.close();
        }
        catch (ZipException zipFile) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return dependencies;
    }

    public static String getModVersion(Path file) {
        if (!file.getFileName().toString().endsWith(".jar")) {
            return null;
        }
        String modVersion = null;
        try {
            ZipFile zipFile = new ZipFile(file.toFile());
            ZipEntry entry = null;
            if (zipFile.getEntry("fabric.mod.json") != null) {
                entry = zipFile.getEntry("fabric.mod.json");
            } else if (zipFile.getEntry("quilt.mod.json") != null) {
                entry = zipFile.getEntry("quilt.mod.json");
            } else if (zipFile.getEntry("META-INF/mods.toml") != null) {
                entry = zipFile.getEntry("META-INF/mods.toml");
            } else if (zipFile.getEntry("META-INF/neoforge.mods.toml") != null) {
                entry = zipFile.getEntry("META-INF/neoforge.mods.toml");
            }
            if (entry == null) {
                zipFile.close();
                return null;
            }
            Gson gson = new Gson();
            InputStream stream = zipFile.getInputStream(entry);
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            if (entry.getName().equals("META-INF/mods.toml") || entry.getName().equals("META-INF/neoforge.mods.toml")) {
                TomlParseResult result = Toml.parse(reader);
                result.errors().forEach(error -> GlobalVariables.LOGGER.error(error.toString()));
                TomlArray array = result.getArray("mods");
                if (array != null) {
                    for (Object o : array.toList()) {
                        TomlTable mod = (TomlTable)o;
                        if (mod == null) continue;
                        modVersion = mod.getString("version");
                    }
                }
                if ("${file.jarVersion}".equals(modVersion)) {
                    ZipEntry manifestEntry = zipFile.getEntry("META-INF/MANIFEST.MF");
                    if (manifestEntry == null) {
                        reader.close();
                        stream.close();
                        zipFile.close();
                        return null;
                    }
                    InputStream fileStream = zipFile.getInputStream(manifestEntry);
                    modVersion = ManifestReader.readForgeModVersion(fileStream);
                }
            } else {
                JsonObject quiltLoader;
                JsonObject json = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
                if (entry.getName().equals("fabric.mod.json")) {
                    if (json.has("version")) {
                        modVersion = json.get("version").getAsString();
                    }
                } else if (entry.getName().equals("quilt.mod.json") && json.has("quilt_loader") && (quiltLoader = json.get("quilt_loader").getAsJsonObject()).has("version")) {
                    modVersion = quiltLoader.get("version").getAsString();
                }
            }
            reader.close();
            stream.close();
            zipFile.close();
        }
        catch (ZipException zipFile) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return modVersion;
    }

    public static Set<String> getAllProvidedIDs(Path file) {
        if (!file.getFileName().toString().endsWith(".jar")) {
            return null;
        }
        HashSet<String> providedIDs = new HashSet<String>();
        try {
            ZipFile zipFile = new ZipFile(file.toFile());
            ZipEntry entry = null;
            if (zipFile.getEntry("fabric.mod.json") != null) {
                entry = zipFile.getEntry("fabric.mod.json");
            } else if (zipFile.getEntry("quilt.mod.json") != null) {
                entry = zipFile.getEntry("quilt.mod.json");
            } else if (zipFile.getEntry("META-INF/mods.toml") != null) {
                entry = zipFile.getEntry("META-INF/mods.toml");
            } else if (zipFile.getEntry("META-INF/neoforge.mods.toml") != null) {
                entry = zipFile.getEntry("META-INF/neoforge.mods.toml");
            }
            if (entry == null) {
                zipFile.close();
                return null;
            }
            Gson gson = new Gson();
            InputStream stream = zipFile.getInputStream(entry);
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            if (entry.getName().equals("META-INF/mods.toml") || entry.getName().equals("META-INF/neoforge.mods.toml")) {
                TomlParseResult result = Toml.parse(reader);
                result.errors().forEach(error -> GlobalVariables.LOGGER.error(error.toString()));
                TomlArray modsArray = result.getArray("mods");
                if (modsArray != null) {
                    for (int i = 0; i < modsArray.size(); ++i) {
                        TomlArray providesArray;
                        TomlTable mod = modsArray.getTable(i);
                        if (mod == null || (providesArray = mod.getArray("provides")) == null) continue;
                        for (int j = 0; j < providesArray.size(); ++j) {
                            String id = providesArray.getString(j);
                            if (id == null || id.isEmpty()) continue;
                            providedIDs.add(id);
                        }
                    }
                }
            } else {
                JsonObject quiltLoader;
                JsonObject json = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
                if (entry.getName().equals("fabric.mod.json")) {
                    if (json.has("provides")) {
                        for (JsonElement provides : json.get("provides").getAsJsonArray()) {
                            providedIDs.add(provides.getAsString());
                        }
                    }
                } else if (entry.getName().equals("quilt.mod.json") && json.has("quilt_loader") && (quiltLoader = json.get("quilt_loader").getAsJsonObject()).has("provides")) {
                    for (JsonElement provides : quiltLoader.get("provides").getAsJsonArray()) {
                        JsonObject providesObject = provides.getAsJsonObject();
                        String id = providesObject.get("id").getAsString();
                        providedIDs.add(id);
                    }
                }
            }
            reader.close();
            stream.close();
            zipFile.close();
        }
        catch (ZipException zipFile) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return providedIDs;
    }

    public static LoaderService.EnvironmentType getModEnvironment(Path file) {
        if (!file.getFileName().toString().endsWith(".jar")) {
            return null;
        }
        LoaderService.EnvironmentType environmentType = LoaderService.EnvironmentType.UNIVERSAL;
        try {
            ZipFile zipFile = new ZipFile(file.toFile());
            ZipEntry entry = null;
            if (zipFile.getEntry("fabric.mod.json") != null) {
                entry = zipFile.getEntry("fabric.mod.json");
            } else if (zipFile.getEntry("quilt.mod.json") != null) {
                entry = zipFile.getEntry("quilt.mod.json");
            } else if (zipFile.getEntry("META-INF/mods.toml") != null) {
                entry = zipFile.getEntry("META-INF/mods.toml");
            } else if (zipFile.getEntry("META-INF/neoforge.mods.toml") != null) {
                entry = zipFile.getEntry("META-INF/neoforge.mods.toml");
            }
            if (entry == null) {
                zipFile.close();
                return null;
            }
            Gson gson = new Gson();
            InputStream stream = zipFile.getInputStream(entry);
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            if (!entry.getName().equals("META-INF/mods.toml") && !entry.getName().equals("META-INF/neoforge.mods.toml")) {
                JsonObject quiltLoader;
                JsonObject json = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
                if (entry.getName().equals("fabric.mod.json")) {
                    if (json.has("environment")) {
                        String environment;
                        environmentType = switch (environment = json.get("environment").getAsString()) {
                            case "client" -> LoaderService.EnvironmentType.CLIENT;
                            case "server" -> LoaderService.EnvironmentType.SERVER;
                            default -> environmentType;
                        };
                    }
                } else if (entry.getName().equals("quilt.mod.json") && json.has("quilt_loader") && (quiltLoader = json.get("minecraft").getAsJsonObject()).has("environment")) {
                    String environment;
                    environmentType = switch (environment = quiltLoader.get("environment").getAsString()) {
                        case "client" -> LoaderService.EnvironmentType.CLIENT;
                        case "dedicated_server" -> LoaderService.EnvironmentType.SERVER;
                        default -> environmentType;
                    };
                }
            }
            reader.close();
            stream.close();
            zipFile.close();
        }
        catch (ZipException zipFile) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return environmentType;
    }

    public static boolean isInValidFileName(String fileName) {
        for (char c : forbiddenChars.toCharArray()) {
            if (fileName.indexOf(c) == -1) continue;
            return true;
        }
        return fileName.trim().isEmpty();
    }

    public static String fixFileName(String fileName) {
        for (char c : forbiddenChars.toCharArray()) {
            fileName = fileName.replace(c, '-');
        }
        fileName = fileName.trim();
        return fileName;
    }
}

