/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_core.utils;

import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import pl.skidam.automodpack_core.GlobalVariables;
import pl.skidam.automodpack_core.config.ConfigTools;
import pl.skidam.automodpack_core.config.Jsons;
import pl.skidam.automodpack_core.utils.FileInspection;

public class WorkaroundUtil {
    public final Path modpackPath;
    public final Path workaroundFile;

    public WorkaroundUtil(Path modapckPath) {
        this.modpackPath = modapckPath;
        this.workaroundFile = this.modpackPath.resolve("workaround.json");
    }

    public Set<String> getWorkaroundMods(Jsons.ModpackContentFields modpackContentFields) {
        HashSet<String> workaroundMods = new HashSet<String>();
        if (GlobalVariables.LOADER == null || !GlobalVariables.LOADER.contains("forge")) {
            return workaroundMods;
        }
        for (Jsons.ModpackContentFields.ModpackContentItem mod : modpackContentFields.list) {
            Path modPath;
            if (!mod.type.equals("mod") || !FileInspection.hasSpecificServices(modPath = Path.of(String.valueOf(this.modpackPath) + mod.file, new String[0]))) continue;
            workaroundMods.add(mod.file);
        }
        Set<String> savedWorkaroundMods = this.getWorkaroundList();
        workaroundMods.addAll(savedWorkaroundMods);
        return workaroundMods;
    }

    public void saveWorkaroundList(Set<String> workaroundMods) {
        Jsons.WorkaroundFields workaroundFields = new Jsons.WorkaroundFields();
        workaroundFields.workaroundMods = workaroundMods;
        ConfigTools.save(this.workaroundFile, workaroundFields);
    }

    public Set<String> getWorkaroundList() {
        Jsons.WorkaroundFields workaroundFields = ConfigTools.load(this.workaroundFile, Jsons.WorkaroundFields.class);
        if (workaroundFields == null || workaroundFields.workaroundMods == null) {
            return new HashSet<String>();
        }
        int previousWorkaroundVersion = workaroundFields.DO_NOT_CHANGE_IT;
        workaroundFields.DO_NOT_CHANGE_IT = new Jsons.WorkaroundFields().DO_NOT_CHANGE_IT;
        if (previousWorkaroundVersion != workaroundFields.DO_NOT_CHANGE_IT) {
            GlobalVariables.LOGGER.info("Updated workaround file version to {}", (Object)GlobalVariables.clientConfig.DO_NOT_CHANGE_IT);
        }
        return workaroundFields.workaroundMods;
    }

    public Path getWorkaroundFile() {
        return this.workaroundFile;
    }
}

