/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_loader_core;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import pl.skidam.automodpack_core.GlobalVariables;
import pl.skidam.automodpack_core.config.Jsons;
import pl.skidam.automodpack_core.loader.LoaderService;
import pl.skidam.automodpack_core.utils.CustomFileUtils;
import pl.skidam.automodpack_loader_core.ReLauncher;
import pl.skidam.automodpack_loader_core.loader.LoaderManager;
import pl.skidam.automodpack_loader_core.platforms.ModrinthAPI;
import pl.skidam.automodpack_loader_core.screen.ScreenManager;
import pl.skidam.automodpack_loader_core.utils.DownloadManager;
import pl.skidam.automodpack_loader_core.utils.UpdateType;

public class SelfUpdater {
    public static final String AUTOMODPACK_ID = "k68glP2e";

    public static boolean update() {
        return SelfUpdater.update(null);
    }

    public static boolean update(Jsons.ModpackContentFields serverModpackContent) {
        LoaderManager loader = new LoaderManager();
        if (loader.isDevelopmentEnvironment()) {
            return false;
        }
        if (loader.getEnvironmentType() == LoaderService.EnvironmentType.SERVER && !GlobalVariables.serverConfig.selfUpdater) {
            GlobalVariables.LOGGER.info("AutoModpack self-updater is disabled in server config.");
            return false;
        }
        List<Object> modrinthAPIList = new ArrayList();
        boolean gettingServerVersion = false;
        if (serverModpackContent != null && serverModpackContent.automodpackVersion != null) {
            modrinthAPIList.add(ModrinthAPI.getModSpecificVersion(AUTOMODPACK_ID, serverModpackContent.automodpackVersion, serverModpackContent.mcVersion));
            gettingServerVersion = true;
        } else {
            modrinthAPIList = ModrinthAPI.getModInfosFromID(AUTOMODPACK_ID);
        }
        if (gettingServerVersion) {
            GlobalVariables.LOGGER.info("Syncing AutoModpack to server version: {}", (Object)serverModpackContent.automodpackVersion);
        } else {
            if (loader.getEnvironmentType() == LoaderService.EnvironmentType.CLIENT && !GlobalVariables.clientConfig.selfUpdater) {
                GlobalVariables.LOGGER.info("AutoModpack self-updater is disabled in client config.");
                return false;
            }
            GlobalVariables.LOGGER.info("Checking if AutoModpack is up-to-date...");
        }
        Object message = "Couldn't get latest version of AutoModpack from Modrinth API. Likely automodpack isn't updated to your version of minecraft yet...";
        if (modrinthAPIList == null) {
            GlobalVariables.LOGGER.warn((String)message);
            return false;
        }
        for (ModrinthAPI modrinthAPI : modrinthAPIList) {
            if (modrinthAPI == null || modrinthAPI.fileVersion() == null) {
                message = "Couldn't get latest version of AutoModpack from Modrinth API. Likely automodpack isn't updated to your version of minecraft yet...";
                continue;
            }
            String fileVersion = modrinthAPI.fileVersion();
            if (fileVersion.equals(GlobalVariables.AM_VERSION)) {
                message = "Didn't find any updates for AutoModpack!";
                continue;
            }
            boolean currentBeta = GlobalVariables.AM_VERSION.contains("-beta");
            boolean remoteBeta = fileVersion.contains("-beta");
            String[] currentVersionSplit = GlobalVariables.AM_VERSION.split("-beta");
            String[] remoteVersionSplit = fileVersion.split("-beta");
            String OUR_VERSION = currentVersionSplit[0].replace(".", "");
            String LATEST_VERSION = remoteVersionSplit[0].replace(".", "");
            if (!gettingServerVersion) {
                try {
                    if (Integer.parseInt(OUR_VERSION) > Integer.parseInt(LATEST_VERSION)) {
                        message = "You are using pre-released or beta version of AutoModpack: " + GlobalVariables.AM_VERSION + " latest stable version is: " + modrinthAPI.fileVersion();
                        break;
                    }
                }
                catch (NumberFormatException e) {
                    GlobalVariables.LOGGER.error("Failed to parse version numbers: " + String.valueOf(e));
                }
                if (currentBeta && remoteBeta && Integer.parseInt(currentVersionSplit[1]) > Integer.parseInt(remoteVersionSplit[1])) {
                    message = "You are using pre-released or beta version of AutoModpack: " + GlobalVariables.AM_VERSION + " latest stable version is: " + modrinthAPI.fileVersion();
                    break;
                }
                if (!currentBeta && remoteBeta) {
                    message = "You are using stable version of AutoModpack: " + GlobalVariables.AM_VERSION + " latest pre-released or beta version is: " + modrinthAPI.fileVersion();
                    continue;
                }
                if (currentBeta && !remoteBeta) {
                    message = "You are using pre-released or beta version of AutoModpack: " + GlobalVariables.AM_VERSION + " latest stable version is: " + modrinthAPI.fileVersion();
                    continue;
                }
            }
            if (modrinthAPI.SHA1Hash().equals(CustomFileUtils.getHash(GlobalVariables.AUTOMODPACK_JAR, "SHA-1").orElse("null"))) {
                message = "Didn't find any updates for AutoModpack! You are on the latest version: " + GlobalVariables.AM_VERSION;
                break;
            }
            GlobalVariables.LOGGER.info("Update found! Updating to the {} version: {}", (Object)(gettingServerVersion ? "server" : "latest"), (Object)modrinthAPI.fileVersion());
            SelfUpdater.installModVersion(modrinthAPI);
            return true;
        }
        GlobalVariables.LOGGER.info((String)message);
        return false;
    }

    public static void installModVersion(ModrinthAPI automodpack) {
        Path automodpackUpdateJar = GlobalVariables.automodpackDir.resolve(automodpack.fileName());
        try {
            DownloadManager downloadManager = new DownloadManager();
            new ScreenManager().download(downloadManager, "AutoModapck " + automodpack.fileVersion());
            downloadManager.download(automodpackUpdateJar, automodpack.SHA1Hash(), new DownloadManager.Urls().addUrl(new DownloadManager.Url().getUrl(automodpack.downloadUrl())), () -> GlobalVariables.LOGGER.info("Downloaded update for AutoModpack."), () -> GlobalVariables.LOGGER.error("Failed to download update for AutoModpack."));
            downloadManager.joinAll();
            downloadManager.cancelAllAndShutdown();
            Path newAutomodpackJar = GlobalVariables.AUTOMODPACK_JAR.getParent().resolve(automodpackUpdateJar.getFileName());
            new ReLauncher();
            UpdateType updateType = UpdateType.AUTOMODPACK;
            CustomFileUtils.copyFile(automodpackUpdateJar, newAutomodpackJar);
            CustomFileUtils.forceDelete(automodpackUpdateJar);
            new ReLauncher(updateType).restart(true, () -> {
                CustomFileUtils.forceDelete(GlobalVariables.AUTOMODPACK_JAR);
                GlobalVariables.LOGGER.info("Successfully updated AutoModpack!");
            });
        }
        catch (Exception e) {
            GlobalVariables.LOGGER.error("Failed to update! " + String.valueOf(e));
        }
    }
}

