/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_loader_core.client;

import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import pl.skidam.automodpack_core.GlobalVariables;
import pl.skidam.automodpack_core.callbacks.Callback;
import pl.skidam.automodpack_core.config.ConfigTools;
import pl.skidam.automodpack_core.config.Jsons;
import pl.skidam.automodpack_core.loader.LoaderService;
import pl.skidam.automodpack_core.utils.CustomFileUtils;
import pl.skidam.automodpack_core.utils.MmcPackMagic;
import pl.skidam.automodpack_core.utils.WorkaroundUtil;
import pl.skidam.automodpack_loader_core.ReLauncher;
import pl.skidam.automodpack_loader_core.client.Changelogs;
import pl.skidam.automodpack_loader_core.client.ModpackUtils;
import pl.skidam.automodpack_loader_core.mods.ModpackLoader;
import pl.skidam.automodpack_loader_core.screen.ScreenManager;
import pl.skidam.automodpack_loader_core.utils.DownloadManager;
import pl.skidam.automodpack_loader_core.utils.FetchManager;
import pl.skidam.automodpack_loader_core.utils.UpdateType;

public class ModpackUpdater {
    public Changelogs changelogs = new Changelogs();
    public static DownloadManager downloadManager;
    public static FetchManager fetchManager;
    public static long totalBytesToDownload;
    public static boolean fullDownload;
    private static Jsons.ModpackContentFields serverModpackContent;
    private static String unModifiedSMC;
    private static WorkaroundUtil workaroundUtil;
    public Map<Jsons.ModpackContentFields.ModpackContentItem, DownloadManager.Urls> failedDownloads = new HashMap<Jsons.ModpackContentFields.ModpackContentItem, DownloadManager.Urls>();
    private static final Set<String> newDownloadedFiles;

    public static String getModpackName() {
        return ModpackUpdater.serverModpackContent.modpackName;
    }

    public void startModpackUpdate(Jsons.ModpackContentFields serverModpackContent, String link, Path modpackDir) {
        if (link == null || link.isEmpty() || modpackDir.toString().isEmpty()) {
            throw new IllegalArgumentException("Link or modpackDir is null or empty");
        }
        try {
            Path modpackContentFile = modpackDir.resolve(GlobalVariables.hostModpackContentFile.getFileName());
            workaroundUtil = new WorkaroundUtil(modpackDir);
            if (serverModpackContent == null) {
                this.handleOfflineMode(modpackDir, modpackContentFile, link);
                return;
            }
            ModpackUpdater.serverModpackContent = serverModpackContent;
            unModifiedSMC = ConfigTools.GSON.toJson((Object)serverModpackContent);
            if (!Files.exists(modpackDir, new LinkOption[0])) {
                Files.createDirectories(modpackDir, new FileAttribute[0]);
            }
            if (Files.exists(modpackContentFile, new LinkOption[0])) {
                modpackDir = ModpackUtils.renameModpackDir(serverModpackContent, modpackDir);
                modpackContentFile = modpackDir.resolve(modpackContentFile.getFileName());
                if (!ModpackUtils.isUpdate(serverModpackContent, modpackDir)) {
                    GlobalVariables.LOGGER.info("Modpack is up to date");
                    this.CheckAndLoadModpack(modpackDir, modpackContentFile, link);
                    return;
                }
            } else if (!GlobalVariables.preload.booleanValue()) {
                fullDownload = true;
                new ScreenManager().danger(new ScreenManager().getScreen().orElseThrow(), link, modpackDir, modpackContentFile);
                return;
            }
            GlobalVariables.LOGGER.warn("Modpack update found");
            new ScreenManager().download(downloadManager, ModpackUpdater.getModpackName());
            this.ModpackUpdaterMain(link, modpackDir, modpackContentFile);
        }
        catch (Exception e) {
            GlobalVariables.LOGGER.error("Error while initializing modpack updater", (Throwable)e);
        }
    }

    private void handleOfflineMode(Path modpackDir, Path modpackContentFile, String link) throws Exception {
        if (!Files.exists(modpackContentFile, new LinkOption[0])) {
            return;
        }
        Jsons.ModpackContentFields modpackContent = ConfigTools.loadModpackContent(modpackContentFile);
        if (modpackContent == null) {
            return;
        }
        GlobalVariables.LOGGER.warn("Server is down, or you don't have access to internet, but we still want to load selected modpack");
        this.CheckAndLoadModpack(modpackDir, modpackContentFile, link);
    }

    public void CheckAndLoadModpack(Path modpackDir, Path modpackContentFile, String link) throws Exception {
        boolean requiresRestart = this.applyModpack(modpackDir, modpackContentFile, link);
        if (requiresRestart) {
            GlobalVariables.LOGGER.info("Modpack is not loaded");
            UpdateType updateType = fullDownload ? UpdateType.FULL : UpdateType.UPDATE;
            new ReLauncher(modpackDir, updateType, this.changelogs).restart(true, new Callback[0]);
        }
        if (GlobalVariables.preload.booleanValue()) {
            List<Path> modpackMods = Files.list(modpackDir.resolve("mods")).toList();
            List<Path> standardMods = Files.list(GlobalVariables.MODS_DIR).toList();
            Set standardModsHashes = standardMods.stream().map(path -> CustomFileUtils.getHash(path, "SHA-1").orElse(null)).filter(Objects::nonNull).collect(Collectors.toSet());
            List<Path> modsToLoad = modpackMods.stream().filter(mod -> !standardModsHashes.contains(CustomFileUtils.getHash(mod, "sha1").orElse("null"))).toList();
            new ModpackLoader().loadModpack(modsToLoad);
            return;
        }
        GlobalVariables.LOGGER.info("Modpack is already loaded");
    }

    public void ModpackUpdaterMain(String link, Path modpackDir, Path modpackContentFile) {
        long start = System.currentTimeMillis();
        try {
            modpackDir = ModpackUtils.renameModpackDir(serverModpackContent, modpackDir);
            modpackContentFile = modpackDir.resolve(modpackContentFile.getFileName());
            Iterator<Jsons.ModpackContentFields.ModpackContentItem> iterator = ModpackUpdater.serverModpackContent.list.iterator();
            while (iterator.hasNext()) {
                Jsons.ModpackContentFields.ModpackContentItem modpackContentField = iterator.next();
                String file = modpackContentField.file;
                String serverSHA1 = modpackContentField.sha1;
                Object path = Path.of(String.valueOf(modpackDir) + file, new String[0]);
                if (Files.exists((Path)path, new LinkOption[0]) && modpackContentField.editable) {
                    GlobalVariables.LOGGER.info("Skipping editable file: {}", (Object)file);
                    iterator.remove();
                    continue;
                }
                if (!Files.exists((Path)path, new LinkOption[0])) {
                    path = Path.of(System.getProperty("user.dir") + file, new String[0]);
                }
                if (!Files.exists((Path)path, new LinkOption[0]) || !Objects.equals(serverSHA1, CustomFileUtils.getHash((Path)path, "sha1").orElse(null))) continue;
                GlobalVariables.LOGGER.info("Skipping already downloaded file: {}", (Object)file);
                iterator.remove();
            }
            long startFetching = System.currentTimeMillis();
            LinkedList<FetchManager.FetchData> fetchDatas = new LinkedList<FetchManager.FetchData>();
            for (Jsons.ModpackContentFields.ModpackContentItem modpackContentItem : ModpackUpdater.serverModpackContent.list) {
                totalBytesToDownload += Long.parseLong(modpackContentItem.size);
                String fileType = modpackContentItem.type;
                if (!fileType.equals("mod") && !fileType.equals("shader") && !fileType.equals("resourcepack")) continue;
                fetchDatas.add(new FetchManager.FetchData(modpackContentItem.file, modpackContentItem.sha1, modpackContentItem.murmur, modpackContentItem.size, fileType));
            }
            fetchManager = new FetchManager(fetchDatas);
            new ScreenManager().fetch(fetchManager);
            fetchManager.fetch();
            GlobalVariables.LOGGER.info("Finished fetching urls in {}ms", (Object)(System.currentTimeMillis() - startFetching));
            newDownloadedFiles.clear();
            int wholeQueue = ModpackUpdater.serverModpackContent.list.size();
            GlobalVariables.LOGGER.info("In queue left {} files to download ({}kb)", (Object)wholeQueue, (Object)(totalBytesToDownload / 1024L));
            downloadManager = new DownloadManager(totalBytesToDownload);
            new ScreenManager().download(downloadManager, ModpackUpdater.getModpackName());
            if (wholeQueue > 0) {
                for (Jsons.ModpackContentFields.ModpackContentItem item2 : ModpackUpdater.serverModpackContent.list) {
                    String fileName = item2.file;
                    String serverSHA1 = item2.sha1;
                    Path downloadFile = Paths.get(String.valueOf(modpackDir) + fileName, new String[0]);
                    if (!Files.exists(downloadFile, new LinkOption[0])) {
                        newDownloadedFiles.add(fileName);
                    }
                    DownloadManager.Urls urls = new DownloadManager.Urls();
                    urls.addUrl(new DownloadManager.Url().getUrl(link + serverSHA1));
                    if (fetchManager.getFetchDatas().containsKey(item2.sha1)) {
                        urls.addAllUrls(new DownloadManager.Url().getUrls(fetchManager.getFetchDatas().get(item2.sha1).fetchedData().urls()));
                    }
                    Runnable failureCallback = () -> this.failedDownloads.put(item2, urls);
                    Runnable successCallback = () -> {
                        List<Object> mainPageUrls = new LinkedList();
                        if (fetchManager != null && fetchManager.getFetchDatas().get(item.sha1) != null) {
                            mainPageUrls = fetchManager.getFetchDatas().get(item.sha1).fetchedData().mainPageUrls();
                        }
                        this.changelogs.changesAddedList.put(downloadFile.getFileName().toString(), mainPageUrls);
                    };
                    downloadManager.download(downloadFile, serverSHA1, urls, successCallback, failureCallback);
                }
                downloadManager.joinAll();
                downloadManager.cancelAllAndShutdown();
                GlobalVariables.LOGGER.info("Finished downloading files in {}ms", (Object)(System.currentTimeMillis() - startFetching));
            }
            totalBytesToDownload = 0L;
            HashMap hashMap = new HashMap();
            HashMap<Jsons.ModpackContentFields.ModpackContentItem, DownloadManager.Urls> failedDownloadsSecMap = new HashMap<Jsons.ModpackContentFields.ModpackContentItem, DownloadManager.Urls>(this.failedDownloads);
            failedDownloadsSecMap.forEach((k, v) -> {
                hashesToRefresh.put(k.file, k.sha1);
                this.failedDownloads.remove(k);
                totalBytesToDownload += Long.parseLong(k.size);
            });
            GlobalVariables.LOGGER.warn("Failed to download {} files", (Object)hashMap.size());
            if (!hashMap.isEmpty()) {
                String hashesJson = ConfigTools.GSON.toJson(hashMap.values());
                GlobalVariables.LOGGER.warn("Trying to refresh the modpack content");
                GlobalVariables.LOGGER.info("Sending hashes to refresh: {}", (Object)hashesJson);
                Optional<Jsons.ModpackContentFields> refreshedContentOptional = ModpackUtils.refreshServerModpackContent(link, hashesJson);
                if (refreshedContentOptional.isEmpty()) {
                    GlobalVariables.LOGGER.error("Failed to refresh the modpack content");
                } else {
                    GlobalVariables.LOGGER.info("Successfully refreshed the modpack content");
                    downloadManager = new DownloadManager(totalBytesToDownload);
                    new ScreenManager().download(downloadManager, ModpackUpdater.getModpackName());
                    Jsons.ModpackContentFields refreshedContent = refreshedContentOptional.get();
                    unModifiedSMC = ConfigTools.GSON.toJson((Object)refreshedContent);
                    List<Jsons.ModpackContentFields.ModpackContentItem> refreshedFilteredList = refreshedContent.list.stream().filter(item -> hashesToRefresh.containsKey(item.file)).toList();
                    for (Jsons.ModpackContentFields.ModpackContentItem item3 : refreshedFilteredList) {
                        String fileName = item3.file;
                        String serverSHA1 = item3.sha1;
                        Path downloadFile = Paths.get(String.valueOf(modpackDir) + fileName, new String[0]);
                        DownloadManager.Urls urls = new DownloadManager.Urls();
                        urls.addUrl(new DownloadManager.Url().getUrl(link + serverSHA1));
                        GlobalVariables.LOGGER.info("Retrying to download {} from {}", (Object)fileName, (Object)urls);
                        Runnable failureCallback = () -> this.failedDownloads.put(item3, urls);
                        Runnable successCallback = () -> this.changelogs.changesAddedList.put(downloadFile.getFileName().toString(), null);
                        downloadManager.download(downloadFile, serverSHA1, urls, successCallback, failureCallback);
                    }
                    downloadManager.joinAll();
                    downloadManager.cancelAllAndShutdown();
                    GlobalVariables.LOGGER.info("Finished refreshed downloading files in {}ms", (Object)(System.currentTimeMillis() - startFetching));
                }
            }
            GlobalVariables.LOGGER.info("Done, saving {}", (Object)modpackContentFile.getFileName().toString());
            Files.write(modpackContentFile, unModifiedSMC.getBytes(), new OpenOption[0]);
            Path cwd = Path.of(System.getProperty("user.dir"), new String[0]);
            CustomFileUtils.deleteDummyFiles(cwd, ModpackUpdater.serverModpackContent.list);
            if (GlobalVariables.preload.booleanValue()) {
                GlobalVariables.LOGGER.info("Update completed! Took: {}ms", (Object)(System.currentTimeMillis() - start));
                this.CheckAndLoadModpack(modpackDir, modpackContentFile, link);
            } else {
                this.applyModpack(modpackDir, modpackContentFile, link);
                if (!this.failedDownloads.isEmpty()) {
                    StringBuilder failedFiles = new StringBuilder();
                    for (Map.Entry<Jsons.ModpackContentFields.ModpackContentItem, DownloadManager.Urls> download : this.failedDownloads.entrySet()) {
                        Jsons.ModpackContentFields.ModpackContentItem item4 = download.getKey();
                        DownloadManager.Urls urls = download.getValue();
                        GlobalVariables.LOGGER.error("Failed to download: " + item4.file + " from " + String.valueOf(urls));
                        failedFiles.append(item4.file);
                    }
                    new ScreenManager().error("automodpack.error.files", "Failed to download: " + String.valueOf(failedFiles), "automodpack.error.logs");
                    GlobalVariables.LOGGER.warn("Update *completed* with ERRORS! Took: {}ms", (Object)(System.currentTimeMillis() - start));
                    return;
                }
                GlobalVariables.LOGGER.info("Update completed! Took: {}ms", (Object)(System.currentTimeMillis() - start));
                UpdateType updateType = fullDownload ? UpdateType.FULL : UpdateType.UPDATE;
                new ReLauncher(modpackDir, updateType, this.changelogs).restart(false, new Callback[0]);
            }
        }
        catch (ConnectException | SocketTimeoutException e) {
            GlobalVariables.LOGGER.error("Modpack host of " + link + " is not responding", (Throwable)e);
        }
        catch (InterruptedException e) {
            GlobalVariables.LOGGER.info("Interrupted the download");
        }
        catch (Exception e) {
            new ScreenManager().error("automodpack.error.critical", "\"" + e.getMessage() + "\"", "automodpack.error.logs");
            e.printStackTrace();
        }
    }

    private boolean applyModpack(Path modpackDir, Path modpackContentFile, String link) throws Exception {
        ModpackUtils.selectModpack(modpackDir, link);
        Jsons.ModpackContentFields modpackContent = ConfigTools.loadModpackContent(modpackContentFile);
        if (modpackContent == null) {
            GlobalVariables.LOGGER.error("Modpack content is null");
            return false;
        }
        if (serverModpackContent != null) {
            if (ModpackUpdater.serverModpackContent.loader != null && ModpackUpdater.serverModpackContent.loaderVersion != null && ModpackUpdater.serverModpackContent.loader.equals(GlobalVariables.LOADER)) {
                List<String> UID = switch (GlobalVariables.LOADER) {
                    case "fabric" -> MmcPackMagic.FABRIC_LOADER_UID;
                    case "quilt" -> MmcPackMagic.QUILT_LOADER_UID;
                    case "forge" -> MmcPackMagic.FORGE_LOADER_UID;
                    case "neoforge" -> MmcPackMagic.NEOFORGE_LOADER_UID;
                    default -> null;
                };
                MmcPackMagic.changeVersion(UID, ModpackUpdater.serverModpackContent.loaderVersion);
            }
            if (ModpackUpdater.serverModpackContent.mcVersion != null) {
                MmcPackMagic.changeVersion(MmcPackMagic.MINECRAFT_UID, ModpackUpdater.serverModpackContent.mcVersion);
            }
        }
        Set<String> workaroundMods = this.deleteNonModpackFiles(modpackDir, modpackContentFile, modpackContent, workaroundUtil);
        workaroundUtil.saveWorkaroundList(workaroundMods);
        Set<String> ignoredFiles = this.getIgnoredFiles(modpackContent.list, workaroundMods);
        boolean needsRestart0 = ModpackUtils.correctFilesLocations(modpackDir, modpackContent, ignoredFiles);
        Map<LoaderService.Mod, LoaderService.Mod> dupeMods = ModpackUtils.getDupeMods(modpackDir, workaroundMods);
        boolean needsRestart1 = ModpackUtils.removeDupeMods(dupeMods);
        return needsRestart0 || needsRestart1;
    }

    private Set<String> getIgnoredFiles(Set<Jsons.ModpackContentFields.ModpackContentItem> modpackContentItems, Set<String> workaroundMods) {
        HashSet<String> ignoredFiles = new HashSet<String>();
        for (Jsons.ModpackContentFields.ModpackContentItem modpackContentItem : modpackContentItems) {
            if (modpackContentItem.editable && !newDownloadedFiles.contains(modpackContentItem.file)) {
                ignoredFiles.add(modpackContentItem.file);
            }
            if (!modpackContentItem.type.equals("mod") || workaroundMods.contains(modpackContentItem.file)) continue;
            ignoredFiles.add(modpackContentItem.file);
        }
        return ignoredFiles;
    }

    private Set<String> deleteNonModpackFiles(Path modpackDir, Path modpackContentFile, Jsons.ModpackContentFields modpackContent, WorkaroundUtil workaroundUtil) throws IOException {
        List<String> modpackFiles = modpackContent.list.stream().map(modpackContentField -> modpackContentField.file).toList();
        List<Path> pathList = Files.walk(modpackDir, new FileVisitOption[0]).toList();
        Set<String> workaroundMods = workaroundUtil.getWorkaroundMods(modpackContent);
        ArrayList<Path> parentPaths = new ArrayList<Path>();
        for (Path path : pathList) {
            String formattedFile;
            if (Files.isDirectory(path, new LinkOption[0]) || path.equals(modpackContentFile) || path.equals(workaroundUtil.getWorkaroundFile()) || modpackFiles.contains(formattedFile = CustomFileUtils.formatPath(path, modpackDir))) continue;
            Path runPath = Path.of("." + formattedFile, new String[0]);
            if (Files.exists(runPath, new LinkOption[0]) && CustomFileUtils.compareFileHashes(path, runPath, "SHA-1")) {
                if (!formattedFile.startsWith("/mods/") || workaroundMods.contains(formattedFile)) {
                    GlobalVariables.LOGGER.info("Deleting {} and {}", (Object)path, (Object)runPath);
                    workaroundMods.remove(formattedFile);
                    parentPaths.add(runPath.getParent());
                    CustomFileUtils.forceDelete(runPath);
                }
            } else {
                GlobalVariables.LOGGER.info("Deleting {}", (Object)path);
            }
            parentPaths.add(path.getParent());
            CustomFileUtils.forceDelete(path);
            this.changelogs.changesDeletedList.put(path.getFileName().toString(), null);
        }
        for (Path parentPath : parentPaths) {
            this.deleteEmptyParentDirectoriesRecursively(parentPath);
        }
        return workaroundMods;
    }

    private void deleteEmptyParentDirectoriesRecursively(Path directory) throws IOException {
        if (directory == null || !CustomFileUtils.isEmptyDirectory(directory)) {
            return;
        }
        GlobalVariables.LOGGER.info("Deleting empty directory {}", (Object)directory);
        CustomFileUtils.forceDelete(directory);
        this.deleteEmptyParentDirectoriesRecursively(directory.getParent());
    }

    static {
        totalBytesToDownload = 0L;
        fullDownload = false;
        newDownloadedFiles = new HashSet<String>();
    }
}

