/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_loader_core.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import pl.skidam.automodpack_core.GlobalVariables;
import pl.skidam.automodpack_core.config.ConfigTools;
import pl.skidam.automodpack_core.config.Jsons;
import pl.skidam.automodpack_core.loader.LoaderService;
import pl.skidam.automodpack_core.utils.CustomFileUtils;
import pl.skidam.automodpack_core.utils.FileInspection;
import pl.skidam.automodpack_core.utils.ModpackContentTools;
import pl.skidam.automodpack_core.utils.Url;

public class ModpackUtils {
    public static boolean isUpdate(Jsons.ModpackContentFields serverModpackContent, Path modpackDir) {
        if (serverModpackContent == null || serverModpackContent.list == null) {
            throw new IllegalArgumentException("Server modpack content list is null");
        }
        Optional<Path> optionalClientModpackContentFile = ModpackContentTools.getModpackContentFile(modpackDir);
        if (optionalClientModpackContentFile.isPresent() && Files.exists(optionalClientModpackContentFile.get(), new LinkOption[0])) {
            Jsons.ModpackContentFields clientModpackContent = ConfigTools.loadModpackContent(optionalClientModpackContentFile.get());
            if (clientModpackContent == null) {
                return true;
            }
            GlobalVariables.LOGGER.info("Checking files...");
            for (Jsons.ModpackContentFields.ModpackContentItem modpackContentField : serverModpackContent.list) {
                String file = modpackContentField.file;
                String serverSHA1 = modpackContentField.sha1;
                Path path = Path.of(String.valueOf(modpackDir) + file, new String[0]);
                if (Files.exists(path, new LinkOption[0])) {
                    if (modpackContentField.editable) {
                        continue;
                    }
                } else {
                    Path standardPath = Path.of("." + file, new String[0]);
                    if (Files.exists(standardPath, new LinkOption[0]) && Objects.equals(serverSHA1, CustomFileUtils.getHash(standardPath, "sha1").orElse(null))) {
                        GlobalVariables.LOGGER.info("File {} already exists on client, coping to modpack", (Object)standardPath.getFileName());
                        try {
                            CustomFileUtils.copyFile(standardPath, path);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    GlobalVariables.LOGGER.info("File does not exists {}", (Object)standardPath);
                    return true;
                }
                if (Objects.equals(serverSHA1, CustomFileUtils.getHash(path, "sha1").orElse(null))) continue;
                GlobalVariables.LOGGER.info("File does not match hash {}", (Object)path);
                return true;
            }
            for (Jsons.ModpackContentFields.ModpackContentItem modpackContentField : clientModpackContent.list) {
                if (!serverModpackContent.list.stream().noneMatch(serverModpackContentItem -> serverModpackContentItem.sha1.equals(modpackContentField.sha1))) continue;
                GlobalVariables.LOGGER.info("File does not exist on server {}", (Object)modpackContentField.file);
                return true;
            }
            GlobalVariables.LOGGER.info("{} is up to date!", (Object)modpackDir);
            return false;
        }
        return true;
    }

    public static boolean correctFilesLocations(Path modpackDir, Jsons.ModpackContentFields serverModpackContent, Set<String> ignoreFiles) throws IOException {
        if (serverModpackContent == null || serverModpackContent.list == null) {
            GlobalVariables.LOGGER.error("Server modpack content list is null");
            return false;
        }
        boolean needsRestart = false;
        for (Jsons.ModpackContentFields.ModpackContentItem contentItem : serverModpackContent.list) {
            String formattedFile = contentItem.file;
            if (ignoreFiles.contains(formattedFile)) continue;
            Path modpackFile = Path.of(String.valueOf(modpackDir) + formattedFile, new String[0]).toAbsolutePath().normalize();
            Path runFile = Path.of("." + formattedFile, new String[0]).toAbsolutePath().normalize();
            if (contentItem.type.equals("mod")) {
                runFile = GlobalVariables.MODS_DIR.resolve(formattedFile.replaceFirst("/mods/", ""));
            }
            boolean modpackFileExists = Files.exists(modpackFile, new LinkOption[0]);
            boolean runFileExists = Files.exists(runFile, new LinkOption[0]);
            boolean needsReCheck = true;
            if (modpackFileExists && !runFileExists) {
                if (contentItem.type.equals("mod")) {
                    needsRestart = true;
                    GlobalVariables.LOGGER.info("Applying workaround for {} mod", (Object)formattedFile);
                }
                CustomFileUtils.copyFile(modpackFile, runFile);
            } else if (!modpackFileExists && runFileExists) {
                CustomFileUtils.copyFile(runFile, modpackFile);
                needsReCheck = false;
            } else if (!modpackFileExists) {
                GlobalVariables.LOGGER.error("File {} doesn't exist!? If you see this please report this to the automodpack repo and attach this log https://github.com/Skidamek/AutoModpack/issues", (Object)formattedFile);
                Thread.dumpStack();
            }
            if (!needsReCheck || !Files.exists(runFile, new LinkOption[0]) || Objects.equals(contentItem.sha1, CustomFileUtils.getHash(runFile, "sha1").orElse(null))) continue;
            GlobalVariables.LOGGER.info("Overwriting {} file to the modpack version", (Object)formattedFile);
            CustomFileUtils.copyFile(modpackFile, runFile);
        }
        return needsRestart;
    }

    public static Map<LoaderService.Mod, LoaderService.Mod> getDupeMods(Path modpackPath, Set<String> workaroundMods) throws IOException {
        List<Path> standardMods = Files.list(GlobalVariables.MODS_DIR).toList();
        List<Path> modpackMods = Files.list(modpackPath.resolve("mods")).toList();
        List<LoaderService.Mod> standardModList = standardMods.stream().map(modPath -> GlobalVariables.LOADER_MANAGER.getMod((Path)modPath)).filter(Objects::nonNull).toList();
        List<LoaderService.Mod> modpackModList = modpackMods.stream().map(modPath -> GlobalVariables.LOADER_MANAGER.getMod((Path)modPath)).filter(Objects::nonNull).toList();
        if (standardModList.isEmpty() || modpackModList.isEmpty()) {
            return Map.of();
        }
        HashMap<LoaderService.Mod, LoaderService.Mod> duplicates = new HashMap<LoaderService.Mod, LoaderService.Mod>();
        for (LoaderService.Mod modpackMod : modpackModList) {
            String formattedFile;
            LoaderService.Mod standardMod = standardModList.stream().filter(mod -> mod.modID().equals(modpackMod.modID())).findFirst().orElse(null);
            if (standardMod == null || workaroundMods.contains(formattedFile = CustomFileUtils.formatPath(modpackMod.modPath(), modpackPath))) continue;
            duplicates.put(modpackMod, standardMod);
        }
        return duplicates;
    }

    public static boolean removeDupeMods(Map<LoaderService.Mod, LoaderService.Mod> dupeMods) throws IOException {
        List<Path> standardMods = Files.list(GlobalVariables.MODS_DIR).toList();
        List<LoaderService.Mod> standardModList = standardMods.stream().map(modPath -> GlobalVariables.LOADER_MANAGER.getMod((Path)modPath)).filter(Objects::nonNull).toList();
        if (standardModList.isEmpty()) {
            return false;
        }
        HashSet<LoaderService.Mod> modsToKeep = new HashSet<LoaderService.Mod>();
        for (LoaderService.Mod standardMod : standardModList) {
            if (dupeMods.containsValue(standardMod)) continue;
            modsToKeep.add(standardMod);
            ModpackUtils.addDependenciesRecursively(standardMod, standardModList, modsToKeep);
        }
        HashSet idsToKeep = new HashSet();
        modsToKeep.forEach(mod -> {
            idsToKeep.add(mod.modID());
            idsToKeep.addAll(mod.providesIDs());
        });
        ArrayList<Path> deletedMods = new ArrayList<Path>();
        for (Map.Entry<LoaderService.Mod, LoaderService.Mod> dupeMod : dupeMods.entrySet()) {
            LoaderService.Mod modpackMod = dupeMod.getKey();
            LoaderService.Mod standardMod = dupeMod.getValue();
            Path modpackModPath = modpackMod.modPath();
            Path standardModPath = standardMod.modPath();
            String modId = modpackMod.modID();
            Collection<String> providesIDs = modpackMod.providesIDs();
            ArrayList<String> IDs = new ArrayList<String>(providesIDs);
            IDs.add(modId);
            boolean isDependent = IDs.stream().anyMatch(idsToKeep::contains);
            if (isDependent) {
                String standardModHash;
                String modpackModHash = CustomFileUtils.getHash(modpackModPath, "sha1").orElse(null);
                if (Objects.equals(modpackModHash, standardModHash = (String)CustomFileUtils.getHash(standardModPath, "sha1").orElse(null))) continue;
                GlobalVariables.LOGGER.warn("Changing duplicated mod {} - {} to modpack version - {}", (Object)modId, (Object)standardMod.modVersion(), (Object)modpackMod.modVersion());
                CustomFileUtils.forceDelete(standardModPath);
                CustomFileUtils.copyFile(modpackModPath, standardModPath.getParent().resolve(modpackModPath.getFileName()));
                deletedMods.add(standardModPath);
                continue;
            }
            GlobalVariables.LOGGER.warn("Removing {} mod. It is duplicated modpack mod and no other mods are dependent on it!", (Object)modId);
            CustomFileUtils.forceDelete(standardModPath);
            deletedMods.add(standardModPath);
        }
        return !deletedMods.isEmpty();
    }

    private static void addDependenciesRecursively(LoaderService.Mod mod, Collection<LoaderService.Mod> modList, Set<LoaderService.Mod> modsToKeep) {
        for (String depId : mod.dependencies()) {
            for (LoaderService.Mod modItem : modList) {
                if (!modItem.modID().equals(depId) && !modItem.providesIDs().contains(depId) || !modsToKeep.add(modItem)) continue;
                ModpackUtils.addDependenciesRecursively(modItem, modList, modsToKeep);
            }
        }
    }

    public static Path renameModpackDir(Jsons.ModpackContentFields serverModpackContent, Path modpackDir) {
        if (GlobalVariables.clientConfig.installedModpacks == null || GlobalVariables.clientConfig.selectedModpack == null || GlobalVariables.clientConfig.selectedModpack.isBlank()) {
            return modpackDir;
        }
        String installedModpackName = GlobalVariables.clientConfig.selectedModpack;
        String installedModpackLink = GlobalVariables.clientConfig.installedModpacks.get(installedModpackName);
        String serverModpackName = serverModpackContent.modpackName;
        if (!serverModpackName.equals(installedModpackName) && !serverModpackName.isEmpty()) {
            Path newModpackDir = modpackDir.getParent().resolve(serverModpackName);
            try {
                Files.move(modpackDir, newModpackDir, StandardCopyOption.REPLACE_EXISTING);
                ModpackUtils.removeModpackFromList(installedModpackName);
                GlobalVariables.LOGGER.info("Changed modpack name of {} to {}", (Object)modpackDir.getFileName().toString(), (Object)serverModpackName);
            }
            catch (DirectoryNotEmptyException directoryNotEmptyException) {
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ModpackUtils.selectModpack(newModpackDir, installedModpackLink);
            return newModpackDir;
        }
        return modpackDir;
    }

    public static boolean selectModpack(Path modpackDirToSelect, String modpackLinkToSelect) {
        Path modpackContentFile;
        Jsons.ModpackContentFields modpackContentToSelect;
        String modpackToSelect = modpackDirToSelect.getFileName().toString();
        String selectedModpack = GlobalVariables.clientConfig.selectedModpack;
        String selectedModpackLink = GlobalVariables.clientConfig.installedModpacks.get(selectedModpack);
        Path selectedModpackDir = GlobalVariables.modpacksDir.resolve(selectedModpack);
        Path selectedModpackContentFile = selectedModpackDir.resolve(GlobalVariables.hostModpackContentFile.getFileName());
        Jsons.ModpackContentFields modpackContent = ConfigTools.loadModpackContent(selectedModpackContentFile);
        if (modpackContent != null) {
            Set<String> editableFiles = ModpackUtils.getEditableFiles(modpackContent.list);
            ModpackUtils.preserveEditableFiles(selectedModpackDir, editableFiles);
        }
        if ((modpackContentToSelect = ConfigTools.loadModpackContent(modpackContentFile = modpackDirToSelect.resolve(GlobalVariables.hostModpackContentFile.getFileName()))) != null) {
            Set<String> editableFiles = ModpackUtils.getEditableFiles(modpackContentToSelect.list);
            ModpackUtils.copyPreviousEditableFiles(modpackDirToSelect, editableFiles);
        }
        GlobalVariables.clientConfig.selectedModpack = modpackToSelect;
        ConfigTools.save(GlobalVariables.clientConfigFile, GlobalVariables.clientConfig);
        ModpackUtils.addModpackToList(modpackToSelect, modpackLinkToSelect);
        return !Objects.equals(modpackToSelect, selectedModpack) || !Objects.equals(modpackLinkToSelect, selectedModpackLink);
    }

    public static void removeModpackFromList(String modpackName) {
        if (modpackName == null || modpackName.isEmpty()) {
            return;
        }
        if (GlobalVariables.clientConfig.installedModpacks != null && GlobalVariables.clientConfig.installedModpacks.containsKey(modpackName)) {
            HashMap<String, String> modpacks = new HashMap<String, String>(GlobalVariables.clientConfig.installedModpacks);
            modpacks.remove(modpackName);
            GlobalVariables.clientConfig.installedModpacks = modpacks;
            ConfigTools.save(GlobalVariables.clientConfigFile, GlobalVariables.clientConfig);
        }
    }

    public static void addModpackToList(String modpackName, String link) {
        if (modpackName == null || modpackName.isEmpty() || link == null || link.isEmpty()) {
            return;
        }
        HashMap<String, String> modpacks = new HashMap<String, String>(GlobalVariables.clientConfig.installedModpacks);
        modpacks.put(modpackName, link);
        GlobalVariables.clientConfig.installedModpacks = modpacks;
        ConfigTools.save(GlobalVariables.clientConfigFile, GlobalVariables.clientConfig);
    }

    public static Path getModpackPath(String url, String modpackName) {
        String nameFromUrl = Url.removeHttpPrefix(url);
        if (FileInspection.isInValidFileName(nameFromUrl)) {
            nameFromUrl = FileInspection.fixFileName(nameFromUrl);
        }
        Path modpackDir = Path.of(String.valueOf(GlobalVariables.modpacksDir) + File.separator + nameFromUrl, new String[0]);
        if (!modpackName.isEmpty()) {
            if (GlobalVariables.clientConfig.installedModpacks != null && GlobalVariables.clientConfig.installedModpacks.containsValue(nameFromUrl)) {
                return modpackDir;
            }
            String nameFromName = modpackName;
            if (FileInspection.isInValidFileName(modpackName)) {
                nameFromName = FileInspection.fixFileName(modpackName);
            }
            modpackDir = Path.of(String.valueOf(GlobalVariables.modpacksDir) + File.separator + nameFromName, new String[0]);
        }
        return modpackDir;
    }

    public static Optional<Jsons.ModpackContentFields> requestServerModpackContent(String link) {
        if (link == null) {
            throw new IllegalArgumentException("Link is null");
        }
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)new URL(link).openConnection();
            connection.setRequestMethod("GET");
            Optional<Jsons.ModpackContentFields> optional = ModpackUtils.connectionToModpack(connection);
            return optional;
        }
        catch (Exception e) {
            GlobalVariables.LOGGER.error("Error while getting server modpack content", (Throwable)e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<Jsons.ModpackContentFields> refreshServerModpackContent(String link, String body) {
        if (link == null || body == null) {
            throw new IllegalArgumentException("Link or body is null");
        }
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)new URL(link + "refresh").openConnection();
            connection.setRequestMethod("POST");
            Optional<Jsons.ModpackContentFields> optional = ModpackUtils.connectionToModpack(connection, body);
            return optional;
        }
        catch (Exception e) {
            GlobalVariables.LOGGER.error("Error while getting server modpack content", (Throwable)e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return Optional.empty();
    }

    public static Optional<Jsons.ModpackContentFields> connectionToModpack(HttpURLConnection connection) {
        return ModpackUtils.connectionToModpack(connection, null);
    }

    public static Optional<Jsons.ModpackContentFields> connectionToModpack(HttpURLConnection connection, String body) {
        int responseCode = -1;
        try {
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("User-Agent", "github/skidamek/automodpack/" + GlobalVariables.AM_VERSION);
            if (body != null) {
                connection.setDoOutput(true);
                connection.getOutputStream().write(body.getBytes(StandardCharsets.UTF_8));
            }
            connection.connect();
            responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                return ModpackUtils.parseStreamToModpack(connection.getInputStream());
            }
            GlobalVariables.LOGGER.error("Couldn't connect to modpack server: {} Response Code: {}", (Object)connection.getURL(), (Object)responseCode);
        }
        catch (SocketException | SocketTimeoutException e) {
            GlobalVariables.LOGGER.error("Couldn't connect to modpack server: {} Response Code: {} Error: {}", (Object)connection.getURL(), (Object)responseCode, (Object)e.getCause());
        }
        catch (Exception e) {
            GlobalVariables.LOGGER.error("Error while getting server modpack content", (Throwable)e);
        }
        return Optional.empty();
    }

    public static Optional<Jsons.ModpackContentFields> parseStreamToModpack(InputStream stream) {
        String response = null;
        try (InputStreamReader isr = new InputStreamReader(stream);){
            JsonElement element = new JsonParser().parse((Reader)isr);
            if (element != null && !element.isJsonArray()) {
                JsonObject obj = element.getAsJsonObject();
                response = obj.toString();
            }
        }
        catch (Exception e) {
            GlobalVariables.LOGGER.error("Couldn't parse modpack content", (Throwable)e);
        }
        if (response == null) {
            GlobalVariables.LOGGER.error("Couldn't parse modpack content");
            return Optional.empty();
        }
        Jsons.ModpackContentFields serverModpackContent = (Jsons.ModpackContentFields)ConfigTools.GSON.fromJson(response, Jsons.ModpackContentFields.class);
        if (serverModpackContent == null) {
            GlobalVariables.LOGGER.error("Couldn't parse modpack content");
            return Optional.empty();
        }
        if (serverModpackContent.list.isEmpty()) {
            GlobalVariables.LOGGER.error("Modpack content is empty!");
            return Optional.empty();
        }
        if (ModpackUtils.potentiallyMalicious(serverModpackContent)) {
            return Optional.empty();
        }
        return Optional.of(serverModpackContent);
    }

    public static boolean potentiallyMalicious(Jsons.ModpackContentFields serverModpackContent) {
        String modpackName = serverModpackContent.modpackName;
        if (modpackName.contains("../") || modpackName.contains("/..")) {
            GlobalVariables.LOGGER.error("Modpack content is invalid, it contains /../ in modpack name");
            return true;
        }
        for (Jsons.ModpackContentFields.ModpackContentItem modpackContentItem : serverModpackContent.list) {
            String file = modpackContentItem.file.replace("\\", "/");
            if (file.contains("../") || file.contains("/..")) {
                GlobalVariables.LOGGER.error("Modpack content is invalid, it contains /../ in file name of {}", (Object)file);
                return true;
            }
            String sha1 = modpackContentItem.sha1;
            if (sha1 != null && !sha1.equals("null")) continue;
            GlobalVariables.LOGGER.error("Modpack content is invalid, it contains null sha1 in file of {}", (Object)file);
            return true;
        }
        return false;
    }

    public static void preserveEditableFiles(Path modpackDir, Set<String> editableFiles) {
        for (String file : editableFiles) {
            Path path = Path.of("." + file, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) continue;
            try {
                CustomFileUtils.copyFile(path, Path.of(String.valueOf(modpackDir) + file, new String[0]));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void copyPreviousEditableFiles(Path modpackDir, Set<String> editableFiles) {
        for (String file : editableFiles) {
            Path path = Path.of(String.valueOf(modpackDir) + file, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) continue;
            try {
                CustomFileUtils.copyFile(path, Path.of("." + file, new String[0]));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static Set<String> getEditableFiles(Set<Jsons.ModpackContentFields.ModpackContentItem> modpackContentItems) {
        HashSet<String> editableFiles = new HashSet<String>();
        for (Jsons.ModpackContentFields.ModpackContentItem modpackContentItem : modpackContentItems) {
            if (!modpackContentItem.editable) continue;
            editableFiles.add(modpackContentItem.file);
        }
        return editableFiles;
    }
}

