/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_loader_core.loader;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModDependency;
import net.fabricmc.loader.api.metadata.ModEnvironment;
import pl.skidam.automodpack_core.GlobalVariables;
import pl.skidam.automodpack_core.loader.LoaderService;
import pl.skidam.automodpack_core.utils.FileInspection;

public class LoaderManager
implements LoaderService {
    private Collection<LoaderService.Mod> modList = new ArrayList<LoaderService.Mod>();
    private int lastLoadingModListSize = -1;

    @Override
    public LoaderService.ModPlatform getPlatformType() {
        return LoaderService.ModPlatform.FABRIC;
    }

    @Override
    public boolean isModLoaded(String modId) {
        return FabricLoader.getInstance().isModLoaded(modId);
    }

    @Override
    public Collection<LoaderService.Mod> getModList() {
        Collection mods = FabricLoader.getInstance().getAllMods();
        if (!this.modList.isEmpty() && this.lastLoadingModListSize == mods.size()) {
            return this.modList;
        }
        this.lastLoadingModListSize = mods.size();
        ArrayList<LoaderService.Mod> modList = new ArrayList<LoaderService.Mod>();
        for (ModContainer info : mods) {
            try {
                String modID = info.getMetadata().getId();
                Path path = this.getModPath(modID);
                if (path == null || path.toString().isEmpty()) continue;
                List<String> dependencies = info.getMetadata().getDependencies().stream().filter(d -> d.getKind().equals((Object)ModDependency.Kind.DEPENDS)).map(ModDependency::getModId).toList();
                LoaderService.Mod mod = new LoaderService.Mod(modID, info.getMetadata().getProvides(), info.getMetadata().getVersion().getFriendlyString(), path, this.getModEnvironment(modID), dependencies);
                modList.add(mod);
            }
            catch (Exception exception) {}
        }
        this.modList = modList;
        return this.modList;
    }

    @Override
    public LoaderService.Mod getMod(String modId) {
        for (LoaderService.Mod mod : this.getModList()) {
            if (!mod.modID().equals(modId)) continue;
            return mod;
        }
        return null;
    }

    @Override
    public LoaderService.Mod getMod(Path file) {
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            return null;
        }
        if (!file.getFileName().toString().endsWith(".jar")) {
            return null;
        }
        for (LoaderService.Mod mod : this.getModList()) {
            if (!mod.modPath().toAbsolutePath().equals(file.toAbsolutePath())) continue;
            return mod;
        }
        String modId = FileInspection.getModID(file);
        String modVersion = FileInspection.getModVersion(file);
        LoaderService.EnvironmentType environmentType = this.getModEnvironmentFromNotLoadedJar(file);
        Set<String> dependencies = FileInspection.getModDependencies(file);
        Set<String> providesIDs = FileInspection.getAllProvidedIDs(file);
        if (modId != null && modVersion != null && environmentType != null && dependencies != null) {
            return new LoaderService.Mod(modId, providesIDs, modVersion, file, environmentType, dependencies);
        }
        return null;
    }

    @Override
    public String getLoaderVersion() {
        Optional modContainer = FabricLoader.getInstance().getModContainer("fabricloader");
        return modContainer.map(container -> container.getMetadata().getVersion().getFriendlyString()).orElse(null);
    }

    @Override
    public Path getModPath(String modId) {
        if (!this.isModLoaded(modId)) {
            return null;
        }
        try {
            for (ModContainer modContainer : FabricLoader.getInstance().getAllMods()) {
                if (!modContainer.getMetadata().getId().equals(modId)) continue;
                FileSystem fileSys = ((Path)modContainer.getRootPaths().get(0)).getFileSystem();
                return Path.of(fileSys.toString(), new String[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        GlobalVariables.LOGGER.error("Could not find jar file for " + modId);
        return null;
    }

    @Override
    public LoaderService.EnvironmentType getEnvironmentType() {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            return LoaderService.EnvironmentType.CLIENT;
        }
        return LoaderService.EnvironmentType.SERVER;
    }

    @Override
    public LoaderService.EnvironmentType getModEnvironmentFromNotLoadedJar(Path file) {
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            return null;
        }
        if (!file.getFileName().toString().endsWith(".jar")) {
            return null;
        }
        try {
            ZipFile zipFile = new ZipFile(file.toFile());
            ZipEntry entry = null;
            if (zipFile.getEntry("fabric.mod.json") != null) {
                entry = zipFile.getEntry("fabric.mod.json");
            }
            if (entry != null) {
                Gson gson = new Gson();
                InputStream stream = zipFile.getInputStream(entry);
                BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                JsonObject json = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
                reader.close();
                stream.close();
                zipFile.close();
                if (json.has("environment")) {
                    String env = json.get("environment").getAsString();
                    if (env.equalsIgnoreCase("client")) {
                        return LoaderService.EnvironmentType.CLIENT;
                    }
                    if (env.equalsIgnoreCase("server")) {
                        return LoaderService.EnvironmentType.SERVER;
                    }
                    return LoaderService.EnvironmentType.UNIVERSAL;
                }
            }
        }
        catch (ZipException zipFile) {
        }
        catch (IOException e) {
            GlobalVariables.LOGGER.error("Failed to get mod env from file: " + String.valueOf(file.getFileName()));
            e.printStackTrace();
        }
        return LoaderService.EnvironmentType.UNIVERSAL;
    }

    @Override
    public String getModVersion(String modId) {
        return FabricLoader.getInstance().getModContainer(modId).isPresent() ? ((ModContainer)FabricLoader.getInstance().getModContainer(modId).get()).getMetadata().getVersion().getFriendlyString() : null;
    }

    @Override
    public String getModVersion(Path file) {
        try {
            ZipFile zipFile = new ZipFile(file.toFile());
            ZipEntry entry = null;
            if (zipFile.getEntry("fabric.mod.json") != null) {
                entry = zipFile.getEntry("fabric.mod.json");
            }
            if (entry != null) {
                Gson gson = new Gson();
                InputStream stream = zipFile.getInputStream(entry);
                BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                JsonObject json = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
                reader.close();
                stream.close();
                zipFile.close();
                if (json.has("version")) {
                    return json.get("version").getAsString();
                }
            }
        }
        catch (ZipException ignored) {
            return "UNKNOWN";
        }
        catch (JsonSyntaxException | IOException e) {
            GlobalVariables.LOGGER.error("Failed to get mod version from file: " + String.valueOf(file.getFileName()));
            e.printStackTrace();
        }
        return "UNKNOWN";
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    @Override
    public LoaderService.EnvironmentType getModEnvironment(String modId) {
        Optional container = FabricLoader.getInstance().getModContainer(modId);
        if (container.isEmpty()) {
            return LoaderService.EnvironmentType.UNIVERSAL;
        }
        ModEnvironment env = ((ModContainer)container.get()).getMetadata().getEnvironment();
        if (env == ModEnvironment.CLIENT) {
            return LoaderService.EnvironmentType.CLIENT;
        }
        if (env == ModEnvironment.SERVER) {
            return LoaderService.EnvironmentType.SERVER;
        }
        return LoaderService.EnvironmentType.UNIVERSAL;
    }

    public String getModId(Path file, boolean checkAlsoOutOfContainer) {
        try {
            for (ModContainer modContainer : FabricLoader.getInstance().getAllMods()) {
                FileSystem fileSys = ((Path)modContainer.getRootPaths().get(0)).getFileSystem();
                Path modFile = Paths.get(fileSys.toString(), new String[0]);
                if (!modFile.toAbsolutePath().equals(file.toAbsolutePath())) continue;
                return modContainer.getMetadata().getId();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (checkAlsoOutOfContainer) {
            return this.getModIdFromNotLoadedJar(file);
        }
        return null;
    }

    @Override
    public String getModIdFromNotLoadedJar(Path file) {
        try {
            if (!Files.isRegularFile(file, new LinkOption[0])) {
                return null;
            }
            ZipFile zipFile = new ZipFile(file.toFile());
            ZipEntry entry = null;
            if (zipFile.getEntry("fabric.mod.json") != null) {
                entry = zipFile.getEntry("fabric.mod.json");
            }
            if (entry != null) {
                Gson gson = new Gson();
                InputStream stream = zipFile.getInputStream(entry);
                BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                JsonObject json = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
                reader.close();
                stream.close();
                zipFile.close();
                if (json.has("id")) {
                    return json.get("id").getAsString();
                }
            }
        }
        catch (ZipException ignored) {
            return null;
        }
        catch (IOException e) {
            GlobalVariables.LOGGER.error("Failed to get mod id from file: " + String.valueOf(file.getFileName()));
            e.printStackTrace();
            return null;
        }
        return null;
    }
}

