/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_loader_core.platforms;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import pl.skidam.automodpack_core.GlobalVariables;
import pl.skidam.automodpack_core.utils.Json;
import pl.skidam.automodpack_loader_core.loader.LoaderManager;

public record ModrinthAPI(String modrinthID, String requestUrl, String downloadUrl, String fileVersion, String fileName, long fileSize, String releaseType, String SHA1Hash) {
    private static final String BASE_URL = "https://api.modrinth.com/v2";

    public static List<ModrinthAPI> getModInfosFromID(String modrinthID) {
        String modLoader = new LoaderManager().getPlatformType().toString().toLowerCase();
        Object requestUrl = "https://api.modrinth.com/v2/project/" + modrinthID + "/version?loaders=[\"" + modLoader + "\"]&game_versions=[\"" + GlobalVariables.MC_VERSION + "\"]";
        requestUrl = ((String)requestUrl).replaceAll("\"", "%22");
        ArrayList<ModrinthAPI> modrinthAPIList = new ArrayList<ModrinthAPI>();
        try {
            JsonArray JSONArray = Json.fromUrlAsArray((String)requestUrl);
            if (JSONArray == null) {
                GlobalVariables.LOGGER.warn("Can't find mod for your client, tried link " + (String)requestUrl);
                return null;
            }
            for (JsonElement jsonElement : JSONArray) {
                JsonObject JSONObject = jsonElement.getAsJsonObject();
                String fileVersion = JSONObject.get("version_number").getAsString();
                String releaseType = JSONObject.get("version_type").getAsString();
                JsonObject JSONObjectFiles = JSONObject.getAsJsonArray("files").get(0).getAsJsonObject();
                String downloadUrl = JSONObjectFiles.get("url").getAsString();
                String fileName = JSONObjectFiles.get("filename").getAsString();
                long fileSize = JSONObjectFiles.get("size").getAsLong();
                String SHA1Hash = JSONObjectFiles.get("hashes").getAsJsonObject().get("sha1").getAsString();
                modrinthAPIList.add(new ModrinthAPI(modrinthID, (String)requestUrl, downloadUrl, fileVersion, fileName, fileSize, releaseType, SHA1Hash));
            }
        }
        catch (IndexOutOfBoundsException e) {
            GlobalVariables.LOGGER.warn("Can't find mod for your client, tried link " + (String)requestUrl);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return modrinthAPIList;
    }

    public static ModrinthAPI getModSpecificVersion(String modrinthID, String modVersion, String mcVersion) {
        String modLoader = new LoaderManager().getPlatformType().toString().toLowerCase();
        Object requestUrl = "https://api.modrinth.com/v2/project/" + modrinthID + "/version?loaders=[\"" + modLoader + "\"]&game_versions=[\"" + mcVersion + "\"]";
        requestUrl = ((String)requestUrl).replaceAll("\"", "%22");
        try {
            JsonArray JSONArray = Json.fromUrlAsArray((String)requestUrl);
            if (JSONArray == null) {
                GlobalVariables.LOGGER.warn("Can't find mod for your client, tried link " + (String)requestUrl);
                return null;
            }
            for (JsonElement jsonElement : JSONArray) {
                JsonObject JSONObject = jsonElement.getAsJsonObject();
                String fileVersion = JSONObject.get("version_number").getAsString();
                if (!fileVersion.equals(modVersion)) continue;
                String releaseType = JSONObject.get("version_type").getAsString();
                JsonObject JSONObjectFiles = JSONObject.getAsJsonArray("files").get(0).getAsJsonObject();
                String downloadUrl = JSONObjectFiles.get("url").getAsString();
                String fileName = JSONObjectFiles.get("filename").getAsString();
                long fileSize = JSONObjectFiles.get("size").getAsLong();
                String SHA1Hash = JSONObjectFiles.get("hashes").getAsJsonObject().get("sha1").getAsString();
                return new ModrinthAPI(modrinthID, (String)requestUrl, downloadUrl, fileVersion, fileName, fileSize, releaseType, SHA1Hash);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static List<ModrinthAPI> getModsInfosFromListOfSHA1(List<String> listOfSha1) {
        if (listOfSha1 == null || listOfSha1.isEmpty()) {
            return null;
        }
        String requestUrl = "https://api.modrinth.com/v2/version_files";
        LinkedList<ModrinthAPI> modrinthAPIList = new LinkedList<ModrinthAPI>();
        try {
            JsonObject JSONObjects = Json.fromModrinthUrl(requestUrl, listOfSha1);
            for (String key : JSONObjects.keySet()) {
                JsonObject JSONObject = JSONObjects.getAsJsonObject(key);
                ModrinthAPI modrinthAPI = ModrinthAPI.parseJsonObject(JSONObject, listOfSha1);
                if (modrinthAPI == null) continue;
                modrinthAPIList.add(modrinthAPI);
            }
        }
        catch (Exception e) {
            GlobalVariables.LOGGER.error("Failed to fetch data from Modrinth API", (Throwable)e);
        }
        return modrinthAPIList;
    }

    public static ModrinthAPI getModInfoFromSHA1(String sha1) {
        if (sha1 == null || sha1.isEmpty()) {
            return null;
        }
        Object requestUrl = "https://api.modrinth.com/v2/version_file/" + sha1 + "?algorithm=sha1";
        requestUrl = ((String)requestUrl).replaceAll("\"", "%22");
        try {
            JsonObject JSONObject = Json.fromUrl((String)requestUrl);
            return ModrinthAPI.parseJsonObject(JSONObject, List.of(sha1));
        }
        catch (IndexOutOfBoundsException e) {
            GlobalVariables.LOGGER.warn("Something gone wrong while getting info from Modrinth API: {}", requestUrl);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static ModrinthAPI parseJsonObject(JsonObject JSONObject, List<String> listOfSha1) {
        if (JSONObject == null) {
            return null;
        }
        String modrinthID = JSONObject.get("project_id").getAsString();
        String fileVersion = JSONObject.get("version_number").getAsString();
        String releaseType = JSONObject.get("version_type").getAsString();
        JsonArray filesArray = JSONObject.getAsJsonArray("files");
        JsonObject JSONObjectFile = null;
        String sha1 = listOfSha1.size() == 1 ? listOfSha1.get(0) : null;
        for (JsonElement fileElement : filesArray) {
            JsonObject fileObject = fileElement.getAsJsonObject();
            JsonObject hashesObject = fileObject.getAsJsonObject("hashes");
            String sha1Hash = hashesObject.get("sha1").getAsString();
            if (sha1 != null && sha1.equals(sha1Hash)) {
                JSONObjectFile = fileObject;
                break;
            }
            if (!listOfSha1.contains(sha1Hash)) continue;
            JSONObjectFile = fileObject;
            break;
        }
        if (JSONObjectFile == null) {
            if (sha1 != null) {
                GlobalVariables.LOGGER.error("Can't find file with SHA1 hash: " + sha1);
            }
            return null;
        }
        String downloadUrl = JSONObjectFile.get("url").getAsString();
        String fileName = JSONObjectFile.get("filename").getAsString();
        long fileSize = JSONObjectFile.get("size").getAsLong();
        if (sha1 == null) {
            sha1 = JSONObjectFile.get("hashes").getAsJsonObject().get("sha1").getAsString();
        }
        return new ModrinthAPI(modrinthID, null, downloadUrl, fileVersion, fileName, fileSize, releaseType, sha1);
    }

    public static String getMainPageUrl(String modrinthID, String fileType) {
        return "https://modrinth.com/" + fileType + "/" + modrinthID;
    }
}

