/*
 * Decompiled with CFR 0.152.
 */
package reloc.org.tomlj;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import reloc.org.tomlj.KeyVisitor;
import reloc.org.tomlj.MutableTomlTable;
import reloc.org.tomlj.TomlPosition;
import reloc.org.tomlj.TomlVersion;
import reloc.org.tomlj.ValueVisitor;
import reloc.org.tomlj.internal.TomlParser;
import reloc.org.tomlj.internal.TomlParserBaseVisitor;

final class InlineTableVisitor
extends TomlParserBaseVisitor<MutableTomlTable> {
    private final TomlVersion version;
    private final MutableTomlTable table;
    private final Map<MutableTomlTable, TomlPosition> openTables;

    public InlineTableVisitor(TomlVersion version, TomlPosition position) {
        this.version = version;
        this.table = new MutableTomlTable(version, position);
        this.openTables = new HashMap<MutableTomlTable, TomlPosition>();
    }

    @Override
    public MutableTomlTable visitKeyval(TomlParser.KeyvalContext ctx) {
        Object value;
        List<String> path;
        TomlParser.KeyContext keyContext = ctx.key();
        TomlParser.ValContext valContext = ctx.val();
        if (keyContext != null && valContext != null && (path = keyContext.accept(new KeyVisitor(this.version))) != null && !path.isEmpty() && (value = valContext.accept(new ValueVisitor(this.version))) != null) {
            this.table.set(path, value, new TomlPosition(ctx)).forEach(entry -> this.openTables.putIfAbsent((MutableTomlTable)entry.getKey(), (TomlPosition)entry.getValue()));
        }
        return this.table;
    }

    @Override
    protected MutableTomlTable aggregateResult(MutableTomlTable aggregate, MutableTomlTable nextResult) {
        return this.table;
    }

    @Override
    protected MutableTomlTable defaultResult() {
        return this.table;
    }

    public void defineOpenTables() {
        this.openTables.forEach(MutableTomlTable::define);
        this.openTables.clear();
    }
}

